# -*- coding: utf-8 -*-
"""
Created on Thu Aug 13 11:58:06 2015

Infinite domain with Dirac type initial concentration and no zero-and
first order rate processes x and y directions are assumed to be infinite,
M is released instantaneously over depth at x = 0 and y = 0. 
Equation from Martinus et al 2013; Fisher 1979

M:      Mass discharged
area:   Channel cross-sectional area
Dx:     Dispersion in the longitudinal direction
Dy:     Dispersion in the transverse direction

Solution is valid only when x >> 10L where L = length of the advective zone

@author: ci1vcs
"""

def ADE_Transverse_Mixing(AMass, ADepth, AVelocity, AnArea, ADispersionCoefficients, ATSettle, ADomain):    
    x_step = ADomain.X.Step
    #y_step = ADomain.Y.Step

    dx = ADispersionCoefficients[0]
    dy = ADispersionCoefficients[1]

    x_values = ADomain.X.InclusiveRange()
    y_values = ADomain.Y.InclusiveRange()
    time_values = ADomain.Time.InclusiveRange()

    x_length = ADomain.X.NumberOfSteps()
    y_length = ADomain.Y.NumberOfSteps()
    time_length = ADomain.Time.NumberOfSteps()

    import math
    import numpy as np
    C = np.zeros((x_length, y_length, time_length), float)   

    y_middle = ADomain.Y.MidIndex()
    initial_concentration = AMass / (x_step * AnArea)
    C[0,y_middle,0] = initial_concentration
    
    for x_index in np.arange(0,x_length):
        x = x_values[x_index]            
        for y_index in np.arange(0,y_length):
            y = y_values[y_index]
            for time_index in np.arange(1,time_length):
                t = time_values[time_index] - ATSettle
                
                #C[x_index,y_index,time_index] = ((initial_concentration * x_step/AnArea)/(4*math.pi*ADepth*t*math.sqrt(dx*dy))) * math.exp(-((x-AVelocity*t)**2)/(4*dx*t) - (y**2/(4*dy*t)))
                # old method with mass and area
                C[x_index,y_index,time_index] = (AMass/(4*math.pi*ADepth*t*math.sqrt(dx*dy))) * math.exp(-((x-AVelocity*t)**2)/(4*dx*t) - (y**2/(4*dy*t)))
                #C[x_index,y_index,time_index] = ((initial_concentration *ADepth*x_step*y_step)/(4*math.pi*ADepth*t*math.sqrt(dx*dy))) * math.exp(-((x-AVelocity*t)**2)/(4*dx*t) - (y**2/(4*dy*t)))
       
    return C
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    